definition module windowvalidate


//	Clean Object I/O library, version 1.1

//	Window validation.


import	ostoolbox
import	windowhandle
from	iostate	import IOSt


validateWindowId :: !(Maybe Id) !(IOSt .l .p) -> (!Bool,Id,!IOSt .l .p)
/*	validateWindowId checks whether the Id of the window/dialogue has already been associated
	with open windows/dialogues. 
	If so, False is returned; otherwise True is returned and a proper Id value for the window/dialogue.
*/

validateWindow :: !(WindowHandle .ls .ps) !(WindowHandles .ps) !*OSToolbox
				->	(	!Index
					,	!Point
					,	!Size
					,	!WindowHandle  .ls .ps
					,	!WindowHandles .ps
					,	!*OSToolbox
					)
/*	validateWindow validates the given WindowHandle.
	It assumes that the Ids of the window and controls have already been validated.
	It returns the valid Index, its position and size.
*/

exactWindowPos :: !Size !(Maybe ItemPos) !WindowKind !WindowMode !(WindowHandles .ps) !*OSToolbox
													  -> (!Point, !WindowHandles .ps, !*OSToolbox)
/*	exactWindowPos determines the exact position of a window.
	The size argument must be the exact size of the window.
	The ItemPos argument must be a valid ItemPos attribute. It should not be one of (LeftOf/RightTo/Above/Below)Prev. 
*/

validateViewDomain :: !ViewDomain -> ViewDomain
/*	validateViewDomain ensures that the ViewDomain is atleast MinWindowW by MinWindowH pixels.
	Also, the result value {corner1,corner2} is such that corner1<corner2 (corner1 is left and above of corner2).
*/
